﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Data.Linq;
using System.Linq.Dynamic;
using System.Text;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager.Utilities;

namespace VeteransAffairs.Registries.BusinessManager
{
    public class SurveyManager : BaseBO
    {
        public SurveyManager()
        {
            _defaultSortField = "Workflow.WKF_CASE_ID desc";

        }

        private void SetLoadWith(RegistriesDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();
            lo.LoadWith<WKF_CASE_ACTIVITY>(e => e.WKF_CASE);
            lo.LoadWith<WKF_CASE>(e => e.REFERRAL);
            lo.LoadWith<REFERRAL>(e => e.PATIENT);
            lo.LoadWith<REFERRAL>(e => e.STD_INSTITUTION);
            lo.LoadWith<WKF_CASE_ACTIVITY>(e => e.STD_WKFACTIVITYST);
            lo.LoadWith<WKF_CASE_ACTIVITY>(e => e.STD_WKFACTIVITYTYPE);
            lo.LoadWith<WKF_CASE>(e => e.STD_WKFCASETYPE);
            lo.LoadWith<WKF_CASE>(e => e.PATIENT);
            lo.LoadWith<PATIENT>(e => e.REGISTRY_DEMOGRAPHICs);
            lo.LoadWith<PATIENT>(e => e.STD_INSTITUTION);
            lo.LoadWith<PATIENT>(e => e.STD_GENDER);
            lo.LoadWith<STD_INSTITUTION>(e => e.STD_STATE);
            lo.LoadWith<WKF_CASE_ACTIVITY>(e => e.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITs);
            lo.LoadWith<WKF_CASE_ACTIVITY>(e => e.QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORMs);

            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;

        }

        private void SetLoadWithByStatus(RegistriesDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();
            lo.LoadWith<WKF_CASE_ACTIVITY>(e => e.WKF_CASE);
            lo.LoadWith<WKF_CASE>(e => e.REFERRAL);
            lo.LoadWith<REFERRAL>(e => e.STD_INSTITUTION);
            lo.LoadWith<WKF_CASE_ACTIVITY>(e => e.STD_WKFACTIVITYST);
            lo.LoadWith<WKF_CASE_ACTIVITY>(e => e.STD_WKFACTIVITYTYPE);
            lo.LoadWith<WKF_CASE_ACTIVITY>(e => e.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITs);
            lo.LoadWith<WKF_CASE>(e => e.STD_WKFCASETYPE);
            lo.LoadWith<WKF_CASE>(e => e.PATIENT);

            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;

        }

        private void SetLoadWithSurveyStatus(RegistriesDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();

            lo.LoadWith<WKF_CASE_ACTIVITY>(e => e.WKF_CASE);
            lo.LoadWith<WKF_CASE_ACTIVITY>(e => e.STD_WKFACTIVITYST);

            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;

        }

        private void SetLoadWithPatient(RegistriesDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();
            lo.LoadWith<WKF_CASE_ACTIVITY>(e => e.WKF_CASE);
            lo.LoadWith<WKF_CASE>(e => e.PATIENT);
            lo.LoadWith<PATIENT>(e => e.REGISTRY_DEMOGRAPHICs);
            lo.LoadWith<PATIENT>(e => e.STD_GENDER);

            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;
        }

        private IQueryable<WKF_CASE_ACTIVITY> LinqAll()
        {
            //populate LinqAll
            IQueryable<WKF_CASE_ACTIVITY> tempLinq = (from e in _db.WKF_CASE_ACTIVITies
                                                      select e);

            //TODO - add all business filtering rules 

            return tempLinq;

        }

        private IQueryable<WKF_CASE_ACTIVITY> SelectByStatusLinqFilter(string value, int id)
        {
            IQueryable<WKF_CASE_ACTIVITY> linqFilter = LinqAll();
            linqFilter = from t in linqFilter
                         where t.STD_WKFACTIVITYTYPE_ID == 2 && t.STD_WKFACTIVITYSTS_ID == id
                         select t;

            string fieldSearch = "LAST_NAME";

            var param = Expression.Parameter(typeof(WKF_CASE_ACTIVITY), "PATIENT");

            // e => e.WKF_CASE.PATIENT.LAST_NAME.Contains()
            var name = Expression.PropertyOrField(
                Expression.PropertyOrField(
                Expression.PropertyOrField(param, "WKF_CASE"), "PATIENT"), fieldSearch);
            var search = Expression.Constant(value, typeof(string));

            var body = Expression.Call(name, "Contains", null, search);

            Expression<Func<WKF_CASE_ACTIVITY, bool>> lambda;
            if (String.IsNullOrEmpty(value))
            {
                lambda = x => true;
            }
            else
            {
                lambda = Expression.Lambda<Func<WKF_CASE_ACTIVITY, bool>>(body, param);
            }


            return linqFilter.Where(lambda);
        }

        public IEnumerable<Questionnaire> SelectByStatus(string searchValue, int id, string sort, int maxRows, int startRow)
        {
            if (string.IsNullOrEmpty(sort))
            {
                sort = _defaultSortField;
            }
            using (_db = GetDataContext())
            {

                SetLoadWithByStatus(_db);
                IEnumerable<WKF_CASE_ACTIVITY> entities;
                //entities = SelectByStatusLinqFilter(id).OrderBy(sort).Skip(startRow).Take(maxRows).ToList();
                entities = (from t in SelectByStatusLinqFilter(searchValue, id)
                            join labKitActivities in _db.WKF_CASE_ACTIVITies.Where(a => a.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.LabKit))
                            on t.WKF_CASE_ID equals labKitActivities.WKF_CASE_ID

                            select new
                            {
                                Workflow = t,
                                ShippingDetails = labKitActivities.SHIPPING_DETAILs.FirstOrDefault()
                            })
                                    .OrderBy(sort)
                                    .Select(p => p.Workflow)
                                    .Skip(startRow)
                                    .Take(maxRows);

                IEnumerable<Questionnaire> questionnairies = entities.Select(e => new Questionnaire
                {

                    SurveyId = e.WKF_CASE_ACTIVITY_ID,
                    CaseId = e.WKF_CASE_ID,
                    PatientName = e.WKF_CASE.PATIENT.LAST_NAME + ", " + e.WKF_CASE.PATIENT.FIRST_NAME + " " + e.WKF_CASE.PATIENT.MIDDLE_NAME,
                    StationNumber = e.WKF_CASE.REFERRAL.STD_INSTITUTION.STATIONNUMBER,
                    Institution = e.WKF_CASE.REFERRAL.STD_INSTITUTION.NAME,
                    //Received Date should be deafaulting the Kit Received Date.
                    ReceivedDate = e.SHIPPING_DETAILs.Count() != 0 ?
                        String.Format("{0:d}", e.SHIPPING_DETAILs.First().RECEIVED_DATE.GetValueOrDefault()) : "",

                    SurveyStatus = e.STD_WKFACTIVITYST.NAME,
                    SurveyType = e.WKF_CASE.STD_WKFCASETYPE.Name,
                    Version = e.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITs.Count > 0 ?
                        e.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITs.FirstOrDefault().FORM_2009_FLAG == true ? "2009" :
                        e.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITs.FirstOrDefault().FORM_2012_FLAG == true ? "2012" :
                        "" : ""

                }).ToList();

                using (_db = GetDataContext())
                {
                    foreach (var tt in questionnairies)
                    {
                        int caseId = tt.CaseId;

                        if (tt.ReceivedDate == "")
                        {
                            var ttt = (from cases in _db.WKF_CASEs.OfType<WKF_CASE>()
                                       join acts in _db.WKF_CASE_ACTIVITies on cases.WKF_CASE_ID equals acts.WKF_CASE_ID
                                       join casetype in _db.STD_WKFCASETYPEs on cases.STD_WKFCASETYPE_ID equals casetype.ID
                                       where (cases.WKF_CASE_ID == caseId)
                         && acts.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.LabKit)
                                       select acts.SHIPPING_DETAILs.FirstOrDefault());

                            var shippingDetail = ttt.Select(e => e).FirstOrDefault();
                            if (shippingDetail != null)
                            {
                                tt.ReceivedDate = String.Format("{0:d}", shippingDetail.RECEIVED_DATE);
                            }
                        }
                    }
                }
                return questionnairies;
            }
        }

        public int SelectByStatusCount(string searchValue, int id)
        {
            using (_db = GetDataContext())
            {
                //SetLoadWith(_db);
                return SelectByStatusLinqFilter(searchValue, id).Count();
            }
        }

        public QuestionnairePatient GetPatientByActivityId(int id)
        {

            using (_db = GetDataContext())
            {
                SetLoadWithPatient(_db);

                WKF_CASE_ACTIVITY activity = (from acts in _db.WKF_CASE_ACTIVITies where acts.WKF_CASE_ACTIVITY_ID == id select acts).FirstOrDefault();

                QuestionnairePatient patient = new QuestionnairePatient();

                patient.PatientId = activity.WKF_CASE.PATIENT.PATIENT_ID;
                patient.PatientName = activity.WKF_CASE.PATIENT.FullName;
                patient.PatientDOB = String.Format("{0:d}", activity.WKF_CASE.PATIENT.BIRTH_DATE);
                patient.PatientSSN = activity.WKF_CASE.PATIENT.Snum;
                if (activity.WKF_CASE.PATIENT.STD_GENDER != null)
                {
                    patient.PatientGender = activity.WKF_CASE.PATIENT.STD_GENDER.NAME;
                }
                patient.PatientAddress1 = activity.WKF_CASE.PATIENT.ADDRESS_LINE1;
                patient.PatientAddress2 = activity.WKF_CASE.PATIENT.ADDRESS_LINE2;
                patient.PatientAddress3 = activity.WKF_CASE.PATIENT.ADDRESS_LINE3;
                patient.PatientCity = activity.WKF_CASE.PATIENT.CITY;
                patient.PatientState = activity.WKF_CASE.PATIENT.STATE;
                patient.PatientZip = string.IsNullOrEmpty(activity.WKF_CASE.PATIENT.ZIP_PLUS_4) ?
                    activity.WKF_CASE.PATIENT.POSTAL_CODE :
                    activity.WKF_CASE.PATIENT.POSTAL_CODE + "-" + activity.WKF_CASE.PATIENT.ZIP_PLUS_4;
                patient.PatientHomePhone = activity.WKF_CASE.PATIENT.HOME_PHONE;
                patient.PatientWorkPhone = activity.WKF_CASE.PATIENT.WORK_PHONE;
                patient.PatientCellPhone = activity.WKF_CASE.PATIENT.CELL_PHONE;

                // Enter Alternate address or phone if exists
                if (activity.WKF_CASE.PATIENT.REGISTRY_DEMOGRAPHICs.Count > 0)
                {
                    REGISTRY_DEMOGRAPHIC demographic = activity.WKF_CASE.PATIENT.REGISTRY_DEMOGRAPHICs.FirstOrDefault();
                    if (!string.IsNullOrEmpty(demographic.HOME_PHONE))
                    {
                        patient.PatientHomePhone = demographic.HOME_PHONE;
                    }
                    if (!string.IsNullOrEmpty(demographic.WORK_PHONE))
                    {
                        patient.PatientWorkPhone = demographic.WORK_PHONE;
                    }
                    if (!string.IsNullOrEmpty(demographic.CELL_PHONE))
                    {
                        patient.PatientCellPhone = demographic.CELL_PHONE;
                    }
                    if (!string.IsNullOrEmpty(demographic.ADDRESS_LINE1)
                        || !string.IsNullOrEmpty(demographic.ADDRESS_LINE2)
                        || !string.IsNullOrEmpty(demographic.ADDRESS_LINE3)
                        || !string.IsNullOrEmpty(demographic.CITY)
                        || !string.IsNullOrEmpty(demographic.STATE)
                        || !string.IsNullOrEmpty(demographic.POSTAL_CODE))
                    {
                        patient.PatientAddress1 = demographic.ADDRESS_LINE1;
                        patient.PatientAddress2 = demographic.ADDRESS_LINE2;
                        patient.PatientAddress3 = demographic.ADDRESS_LINE3;
                        patient.PatientCity = demographic.CITY;
                        patient.PatientState = demographic.STATE;
                        patient.PatientZip = string.IsNullOrEmpty(demographic.ZIP_PLUS_4) ?
                            demographic.POSTAL_CODE :
                            demographic.POSTAL_CODE + "-" + demographic.ZIP_PLUS_4;
                    }
                }

                return patient;
            }

        }

        public STD_WKFACTIVITYST GetNameByStatusId(int id)
        {
            STD_WKFACTIVITYST wst;
            using (_db = GetDataContext())
            {

                wst = (from st in _db.STD_WKFACTIVITYSTs where st.ID == id select st).FirstOrDefault();

            }

            return wst;
        }


        public object getSurveyStatusByActivityID(int id)
        {
            using (_db = GetDataContext())
            {
                SetLoadWithSurveyStatus(_db);
                var entity = (from wfs in _db.WKF_CASE_ACTIVITies.Where(r => r.WKF_CASE_ACTIVITY_ID == id)
                              select new QuestionnaireStatus
                              {
                                  CaseId = wfs.WKF_CASE_ID,
                                  Name = wfs.STD_WKFACTIVITYST.NAME
                              }).SingleOrDefault();
                return entity;
            }
        }

        public WKF_CASE_ACTIVITY getSurveyBySurveyID(int id)
        {
            WKF_CASE_ACTIVITY entity;
            using (_db = GetDataContext())
            {
                SetLoadWith(_db);
                entity = (from srv in _db.WKF_CASE_ACTIVITies where srv.WKF_CASE_ACTIVITY_ID == id select srv).FirstOrDefault();
            }

            return entity;
        }

        public WKF_CASE_ACTIVITY Update(WKF_CASE_ACTIVITY caseActivity)
        {
            using (_db = GetDataContext())
            {
                _db.DeferredLoadingEnabled = false;

                caseActivity.SynchroniseWithDataContext(_db); //this line traverses all entities, attaching all of them as appropriate to the data context.

                try
                {
                    _db.SubmitChanges(ConflictMode.ContinueOnConflict);
                }
                catch (ChangeConflictException)
                {
                    _db.ChangeConflicts.ResolveAll(RefreshMode.KeepChanges);
                }
            }

            return caseActivity;
        }

        public class Questionnaire
        {
            public int SurveyId { get; set; }
            public int CaseId { get; set; }
            public string ReceivedDate { get; set; }
            public string PatientName { get; set; }
            public string SurveyStatus { get; set; }
            public string SurveyType { get; set; }
            public string StationNumber { get; set; }
            public string Institution { get; set; }
            public string Version { get; set; }
        }

        public class QuestionnairePatient
        {
            public int PatientId { get; set; }
            public string PatientName { get; set; }
            public string PatientDOB { get; set; }
            public string PatientGender { get; set; }
            public string PatientSSN { get; set; }
            public string PatientAddress1 { get; set; }
            public string PatientAddress2 { get; set; }
            public string PatientAddress3 { get; set; }
            public string PatientCity { get; set; }
            public string PatientState { get; set; }
            public string PatientZip { get; set; }
            public string PatientHomePhone { get; set; }
            public string PatientWorkPhone { get; set; }
            public string PatientCellPhone { get; set; }
        }

        public class QuestionnaireStatus
        {
            public string Name { get; set; }
            public int CaseId { get; set; }

        }
    }
}
